% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_optics.R
\name{register_optics}
\alias{register_optics}
\alias{optics}
\alias{OPTICS}
\title{Register Seriation Based on OPTICS}
\usage{
register_optics()
}
\value{
Nothing.
}
\description{
Use ordering points to identify the clustering structure (OPTICS) for \code{\link[=seriate]{seriate()}}.
}
\details{
Registers the method \code{"optics"} for \code{\link[=seriate]{seriate()}}. This method applies
the OPTICS ordering algorithm implemented in \code{\link[dbscan:optics]{dbscan::optics()}} to create an ordering.

\strong{Note:} Package \pkg{dbscan} needs to be installed.
}
\examples{

\dontrun{
register_optics()
get_seriation_method("dist", "optics")

d <- dist(random.robinson(50, pre=TRUE, noise=.1))

o <- seriate(d, method = "optics")
pimage(d, o)
}

}
\references{
Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, Joerg
Sander (1999). OPTICS: Ordering Points To Identify the Clustering Structure.
\emph{ACM SIGMOD international conference on Management of data,} ACM Press, pp.
49-60. \doi{10.1145/304181.304187}
}
\seealso{
\code{\link[dbscan:optics]{dbscan::optics()}}.

Other seriation: 
\code{\link{register_DendSer}()},
\code{\link{register_GA}()},
\code{\link{register_smacof}()},
\code{\link{register_tsne}()},
\code{\link{register_umap}()},
\code{\link{registry_for_seriation_methods}},
\code{\link{seriate}()},
\code{\link{seriate_best}()}
}
\concept{seriation}
\keyword{cluster}
\keyword{optimize}
