% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{Seurat-package}
\alias{Seurat}
\alias{Seurat-package}
\title{Seurat: Tools for Single Cell Genomics}
\description{
A toolkit for quality control, analysis, and exploration of single cell RNA sequencing data. 'Seurat' aims to enable users to identify and interpret sources of heterogeneity from single cell transcriptomic measurements, and to integrate diverse types of single cell data. See Satija R, Farrell J, Gennert D, et al (2015) \doi{10.1038/nbt.3192}, Macosko E, Basu A, Satija R, et al (2015) \doi{10.1016/j.cell.2015.05.002}, Stuart T, Butler A, et al (2019) \doi{10.1016/j.cell.2019.05.031}, and Hao, Hao, et al (2020) \doi{10.1101/2020.10.12.335331} for more details.
}
\section{Package options}{


Seurat uses the following [options()] to configure behaviour:

\describe{
  \item{\code{Seurat.memsafe}}{global option to call gc() after many operations.
  This can be helpful in cleaning up the memory status of the R session and
  prevent use of swap space. However, it does add to the computational overhead
  and setting to FALSE can speed things up if you're working in an environment
  where RAM availability is not a concern.}
  \item{\code{Seurat.warn.umap.uwot}}{Show warning about the default backend
  for \code{\link{RunUMAP}} changing from Python UMAP via reticulate to UWOT}
  \item{\code{Seurat.checkdots}}{For functions that have ... as a parameter,
  this controls the behavior when an item isn't used. Can be one of warn,
  stop, or silent.}
  \item{\code{Seurat.limma.wilcox.msg}}{{Show message about more efficient
  Wilcoxon Rank Sum test available via the limma package}}
  \item{\code{Seurat.Rfast2.msg}}{{Show message about more efficient
  Moran's I function available via the Rfast2 package}}
  \item{\code{Seurat.warn.vlnplot.split}}{Show message about changes to
  default behavior of split/multi violin plots}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://satijalab.org/seurat}
  \item \url{https://github.com/satijalab/seurat}
  \item Report bugs at \url{https://github.com/satijalab/seurat/issues}
}

}
\author{
\strong{Maintainer}: Rahul Satija \email{seurat@nygenome.org} (\href{https://orcid.org/0000-0001-9448-8833}{ORCID})

Other contributors:
\itemize{
  \item Andrew Butler \email{abutler@nygenome.org} (\href{https://orcid.org/0000-0003-3608-0463}{ORCID}) [contributor]
  \item Saket Choudhary \email{schoudhary@nygenome.org} (\href{https://orcid.org/0000-0001-5202-7633}{ORCID}) [contributor]
  \item David Collins \email{dcollins@nygenome.org} (\href{https://orcid.org/0000-0001-9243-7821}{ORCID}) [contributor]
  \item Charlotte Darby \email{cdarby@nygenome.org} (\href{https://orcid.org/0000-0003-2195-5300}{ORCID}) [contributor]
  \item Jeff Farrell \email{jfarrell@g.harvard.edu} [contributor]
  \item Isabella Grabski \email{igrabski@nygenome.org} (\href{https://orcid.org/0000-0002-0616-5469}{ORCID}) [contributor]
  \item Christoph Hafemeister \email{chafemeister@nygenome.org} (\href{https://orcid.org/0000-0001-6365-8254}{ORCID}) [contributor]
  \item Yuhan Hao \email{yhao@nygenome.org} (\href{https://orcid.org/0000-0002-1810-0822}{ORCID}) [contributor]
  \item Austin Hartman \email{ahartman@nygenome.org} (\href{https://orcid.org/0000-0001-7278-1852}{ORCID}) [contributor]
  \item Paul Hoffman \email{hoff0792@umn.edu} (\href{https://orcid.org/0000-0002-7693-8957}{ORCID}) [contributor]
  \item Jaison Jain \email{jjain@nygenome.org} (\href{https://orcid.org/0000-0002-9478-5018}{ORCID}) [contributor]
  \item Longda Jiang \email{ljiang@nygenome.org} (\href{https://orcid.org/0000-0003-4964-6497}{ORCID}) [contributor]
  \item Madeline Kowalski \email{mkowalski@nygenome.org} (\href{https://orcid.org/0000-0002-5655-7620}{ORCID}) [contributor]
  \item Skylar Li \email{sli@nygenome.org} [contributor]
  \item Gesmira Molla \email{gmolla@nygenome.org} (\href{https://orcid.org/0000-0002-8628-5056}{ORCID}) [contributor]
  \item Efthymia Papalexi \email{epapalexi@nygenome.org} (\href{https://orcid.org/0000-0001-5898-694X}{ORCID}) [contributor]
  \item Patrick Roelli \email{proelli@nygenome.org} [contributor]
  \item Karthik Shekhar \email{kshekhar@berkeley.edu} [contributor]
  \item Avi Srivastava \email{asrivastava@nygenome.org} (\href{https://orcid.org/0000-0001-9798-2079}{ORCID}) [contributor]
  \item Tim Stuart \email{tstuart@nygenome.org} (\href{https://orcid.org/0000-0002-3044-0897}{ORCID}) [contributor]
  \item Kristof Torkenczy (\href{https://orcid.org/0000-0002-4869-7957}{ORCID}) [contributor]
  \item Shiwei Zheng \email{szheng@nygenome.org} (\href{https://orcid.org/0000-0001-6682-6743}{ORCID}) [contributor]
  \item Satija Lab and Collaborators [funder]
}

}
