% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom_write.R
\name{vroom_write}
\alias{vroom_write}
\title{Write a data frame to a delimited file}
\usage{
vroom_write(
  x,
  file,
  delim = "\\t",
  eol = "\\n",
  na = "NA",
  col_names = !append,
  append = FALSE,
  quote = c("needed", "all", "none"),
  escape = c("double", "backslash", "none"),
  bom = FALSE,
  num_threads = vroom_threads(),
  progress = vroom_progress(),
  path = deprecated()
)
}
\arguments{
\item{x}{A data frame or tibble to write to disk.}

\item{file}{File or connection to write to.}

\item{delim}{Delimiter used to separate values. Defaults to \verb{\\t} to write
tab separated value (TSV) files.}

\item{eol}{The end of line character to use. Most commonly either \code{"\n"} for
Unix style newlines, or \code{"\r\n"} for Windows style newlines.}

\item{na}{String used for missing values. Defaults to 'NA'.}

\item{col_names}{If \code{FALSE}, column names will not be included at the top of the file. If \code{TRUE},
column names will be included. If not specified, \code{col_names} will take the opposite value given to \code{append}.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if the file does not exist a new
file is created.}

\item{quote}{How to handle fields which contain characters that need to be quoted.
\itemize{
\item \code{needed} - Only quote fields which need them.
\item \code{all} - Quote all fields.
\item \code{none} - Never quote fields.
}}

\item{escape}{The type of escape to use when quotes are in the data.
\itemize{
\item \code{double} - quotes are escaped by doubling them.
\item \code{backslash} - quotes are escaped by a preceding backslash.
\item \code{none} - quotes are not escaped.
}}

\item{bom}{If \code{TRUE} add a UTF-8 BOM at the beginning of the file. This is
recommended when saving data for consumption by excel, as it will force
excel to read the data with the correct encoding (UTF-8)}

\item{num_threads}{Number of threads to use when reading and materializing
vectors. If your data contains newlines within fields the parser will
automatically be forced to use a single thread only.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} is no longer supported, use
\code{file} instead.}
}
\description{
Write a data frame to a delimited file
}
\examples{
# If you only specify a file name, vroom_write() will write
# the file to your current working directory.
out_file <- tempfile(fileext = "csv")
vroom_write(mtcars, out_file, ",")

# You can also use a literal filename
# vroom_write(mtcars, "mtcars.tsv")

# If you add an extension to the file name, write_()* will
# automatically compress the output.
# vroom_write(mtcars, "mtcars.tsv.gz")
# vroom_write(mtcars, "mtcars.tsv.bz2")
# vroom_write(mtcars, "mtcars.tsv.xz")
}
