#!/bin/sh

. /usr/lib/spamass-milter/default_variables.sh

# Because the default socket is in the same location as the
# pidfile, we create them in this order.
for DIR in "$(dirname $PIDFILE)" "$(dirname $SOCKET)"; do 
    # if the dirname is '.', then it's some kind of odd socket, like
    # an inet socket. Don't create the directory in such a case
	if [ "$DIR" != "." ] && [ ! -d "$DIR" ]; then
	    mkdir -p "$DIR";
	    if [ -x /sbin/restorecon ]; then 
		    /sbin/restorecon "$DIR";
	    fi;
	    if [ -n "$RUNAS" ]; then
		    chown "$RUNAS" "$DIR";
	    fi;
	fi;
done;

# If the socket group is postfix, we need to make sure the user we're
# running as is in the postfix group.
if [ "x$SOCKET_GROUP" = "xpostfix" ]; then
    if [ -n "$RUNAS" ]; then
        usermod -a -G "$SOCKET_GROUP" "$RUNAS"
    fi;
fi;
