use core:lang;
use lang:bs:macro;

Str? convertPrimitive(Type t, unsafe:RawPtr object, Nat offset) {
	if (t is named{core:Bool})
		return object.readBool(offset).toS();
	if (t is named{core:Byte})
		return object.readByte(offset).toS();
	if (t is named{core:Int})
		return object.readInt(offset).toS();
	if (t is named{core:Nat})
		return object.readNat(offset).toS();
	if (t is named{core:Long})
		return object.readLong(offset).toS();
	if (t is named{core:Word})
		return object.readWord(offset).toS();
	if (t is named{core:Float})
		return object.readFloat(offset).toS();
	if (t is named{core:Double})
		return object.readDouble(offset).toS();

	null;
}

/**
 * Type information usable from other threads than the Compiler thread.
 */
value TypeInfo {
	Type type;
	Bool isValue;
	Bool isRef;

	init(Type type, Bool isValue, Bool isRef) {
		init {
			type = type; isValue = isValue; isRef = isRef;
		}
	}
}

/**
 * Description of members.
 */
value MemberOffset {
	Str name;
	Nat offset;
	TypeInfo type;
	Bool first;

	init(Str name, Nat offset, TypeInfo type, Bool first) {
		init {
			name = name;
			offset = offset;
			type = type;
			first = first;
		}
	}
}

void appendMembers(Type t, MemberOffset[] result) on Compiler {
	if (super = t.super) {
		// Don't add members from TObject...
		if (super !is named{TObject})
			appendMembers(super, result);
	}

	MemberOffset[] here;
	for (elem in t) {
		if (elem as MemberVar) {
			Value memberType = elem.type;

			// We can just ignore maybe-types!
			if (!memberType.ref) {
				var unwrapped = unwrapMaybe(memberType);
				if (!unwrapped.isValue)
					memberType = unwrapped;
			}

			if (type = memberType.type) {
				TypeInfo info(type, memberType.isValue, memberType.ref);
				here << MemberOffset(elem.name, elem.offset.current.nat, info, false);
			}
		}
	}

	here.sort((x, y) => x.offset < y.offset);

	if (here.any)
		here[0].first = true;

	// Add them to the parameter.
	for (h in here)
		result << h;
}

MemberOffset[] findMembers(Type t) on Compiler {
	t.forceLoad();
	MemberOffset[] result;
	appendMembers(t, result);
	result;
}
