package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebootInstances invokes the ecs.RebootInstances API synchronously
func (client *Client) RebootInstances(request *RebootInstancesRequest) (response *RebootInstancesResponse, err error) {
	response = CreateRebootInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// RebootInstancesWithChan invokes the ecs.RebootInstances API asynchronously
func (client *Client) RebootInstancesWithChan(request *RebootInstancesRequest) (<-chan *RebootInstancesResponse, <-chan error) {
	responseChan := make(chan *RebootInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebootInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebootInstancesWithCallback invokes the ecs.RebootInstances API asynchronously
func (client *Client) RebootInstancesWithCallback(request *RebootInstancesRequest, callback func(response *RebootInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebootInstancesResponse
		var err error
		defer close(result)
		response, err = client.RebootInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebootInstancesRequest is the request struct for api RebootInstances
type RebootInstancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BatchOptimization    string           `position:"Query" name:"BatchOptimization"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ForceReboot          requests.Boolean `position:"Query" name:"ForceReboot"`
	InstanceId           *[]string        `position:"Query" name:"InstanceId"  type:"Repeated"`
}

// RebootInstancesResponse is the response struct for api RebootInstances
type RebootInstancesResponse struct {
	*responses.BaseResponse
	RequestId         string                             `json:"RequestId" xml:"RequestId"`
	InstanceResponses InstanceResponsesInRebootInstances `json:"InstanceResponses" xml:"InstanceResponses"`
}

// CreateRebootInstancesRequest creates a request to invoke RebootInstances API
func CreateRebootInstancesRequest() (request *RebootInstancesRequest) {
	request = &RebootInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "RebootInstances", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRebootInstancesResponse creates a response to parse from RebootInstances response
func CreateRebootInstancesResponse() (response *RebootInstancesResponse) {
	response = &RebootInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
