package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateVpcGatewayEndpointAttribute invokes the vpc.UpdateVpcGatewayEndpointAttribute API synchronously
func (client *Client) UpdateVpcGatewayEndpointAttribute(request *UpdateVpcGatewayEndpointAttributeRequest) (response *UpdateVpcGatewayEndpointAttributeResponse, err error) {
	response = CreateUpdateVpcGatewayEndpointAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateVpcGatewayEndpointAttributeWithChan invokes the vpc.UpdateVpcGatewayEndpointAttribute API asynchronously
func (client *Client) UpdateVpcGatewayEndpointAttributeWithChan(request *UpdateVpcGatewayEndpointAttributeRequest) (<-chan *UpdateVpcGatewayEndpointAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateVpcGatewayEndpointAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateVpcGatewayEndpointAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateVpcGatewayEndpointAttributeWithCallback invokes the vpc.UpdateVpcGatewayEndpointAttribute API asynchronously
func (client *Client) UpdateVpcGatewayEndpointAttributeWithCallback(request *UpdateVpcGatewayEndpointAttributeRequest, callback func(response *UpdateVpcGatewayEndpointAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateVpcGatewayEndpointAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateVpcGatewayEndpointAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateVpcGatewayEndpointAttributeRequest is the request struct for api UpdateVpcGatewayEndpointAttribute
type UpdateVpcGatewayEndpointAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	EndpointId           string           `position:"Query" name:"EndpointId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndpointDescription  string           `position:"Query" name:"EndpointDescription"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	EndpointName         string           `position:"Query" name:"EndpointName"`
	PolicyDocument       string           `position:"Query" name:"PolicyDocument"`
}

// UpdateVpcGatewayEndpointAttributeResponse is the response struct for api UpdateVpcGatewayEndpointAttribute
type UpdateVpcGatewayEndpointAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateVpcGatewayEndpointAttributeRequest creates a request to invoke UpdateVpcGatewayEndpointAttribute API
func CreateUpdateVpcGatewayEndpointAttributeRequest() (request *UpdateVpcGatewayEndpointAttributeRequest) {
	request = &UpdateVpcGatewayEndpointAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateVpcGatewayEndpointAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateVpcGatewayEndpointAttributeResponse creates a response to parse from UpdateVpcGatewayEndpointAttribute response
func CreateUpdateVpcGatewayEndpointAttributeResponse() (response *UpdateVpcGatewayEndpointAttributeResponse) {
	response = &UpdateVpcGatewayEndpointAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
