/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009,2013 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

#include <stdio.h>


extern int base32_test(unsigned*, unsigned*, unsigned*);
extern int endian_test(unsigned*, unsigned*, unsigned*);
extern int escape_test(unsigned*, unsigned*, unsigned*);
extern int getopt_test(unsigned*, unsigned*, unsigned*);
extern int read_test(unsigned*, unsigned*, unsigned*);
#ifdef USE_TEXTS
extern int texts_test(unsigned*, unsigned*, unsigned*);
#endif /* !USE_TEXTS */
extern int thex_test(unsigned*, unsigned*, unsigned*);
extern int tiger_test(unsigned*, unsigned*, unsigned*);
extern int types_test(unsigned*, unsigned*, unsigned*);
extern int utf8_test(unsigned*, unsigned*, unsigned*);


int main() {
	unsigned success = 0;
	unsigned failure = 0;
	unsigned warning = 0;

	printf("============================================\n");
	printf("  RUNNING TESTS\n");
	printf("--------------------------------------------\n");
	printf("  Language\n--------------------------------------------\n");
	endian_test(&success, &failure, &warning);
	types_test(&success, &failure, &warning);
	printf("--------------------------------------------\n");
	printf("  Util\n--------------------------------------------\n");
	base32_test(&success, &failure, &warning);
	escape_test(&success, &failure, &warning);
	getopt_test(&success, &failure, &warning);
	read_test(&success, &failure, &warning);
	utf8_test(&success, &failure, &warning);
	printf("--------------------------------------------\n");
	printf("  App\n--------------------------------------------\n");
#ifdef USE_TEXTS
	texts_test(&success, &failure, &warning);
#endif /* USE_TEXTS */
	tiger_test(&success, &failure, &warning);
	thex_test(&success, &failure, &warning);
	printf("--------------------------------------------\n");
	printf("  Tests completed: %u succeeded, %u failed\n",
		success, failure);
	if (warning)
		printf("                   %u warning(s)\n", warning);
	printf("============================================\n");

	if (failure)
		return 1;
	return 0;
}
