/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */
#ifndef CLICKLABEL_H
#define CLICKLABEL_H

#include <QLabel>
#include <QMouseEvent>
#include <QPainter>
#include <QStyleOption>

class ClickLabel : public QLabel
{
    Q_OBJECT

public:
    explicit ClickLabel(const QString &text, QWidget *parent = 0);
    ~ClickLabel();

protected:
    void mousePressEvent(QMouseEvent * event);
    //virtual void paintEvent(QPaintEvent * event);

Q_SIGNALS:
    void clicked();
};

#endif // CLICKLABEL_H
