/* -*- c++ -*- */
/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0.3
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _sigc_addon_h_
#define _sigc_addon_h_
#ifdef USE_SIGCPLUSPLUS
#include <sigc++/signal_system.h>

#ifdef SIGC_CXX_NAMESPACES // currently code depends on this!
using namespace std;
using namespace SigC;
#endif

/*!
  \class VDKSignal0
  \brief makes a signal of type: Signal2<Ret, VDKObject*, P1>

   This template basically makes a signal of type:
             Signal2<Ret, VDKObject*, P1>
    what also accepts slots of type:
             Slot1<Ret,P1>
    for VDKSignal1<Ret, P1>.
    Attention: To emit a signal like this you have to call
    'emit(VDKObject* ob, P1)' , that means 'emit(P1)' is not available.
    This must be as we must handle all subscribed signal_receivers equal.
    This nameing convention also applies on the other classes, so
    VDKSignal0<Ret> wraps Signal0<Ret> and Signal1<Ret, VDKObject*>.
 
    For the moment you can not connect two VDKSignal#'s dircetly, as
    VDKSignal#.slot() is not availbale. But in real life (code) you should
    not do it either. Coupling a SigC::Signal# on a VDKSignal# works, what
    is what you (probably) want instead.
*/
template<class Ret, class T>
class DualSignal0 : public SigC::Signal1<Ret, T>,
		    public SigC::Signal0<Ret>
{
private:
/*     Ret emit(){}; // Don't use!!! */
/*     Ret operator()(){} // also */
public:
     typedef SigC::Signal0<Ret> short_signal_t;
     typedef SigC::Signal1<Ret,T> long_signal_t;

     Connection connect(const Slot0<Ret> &sl)
     {return short_signal_t::connect(sl);}

     Connection connect(const Slot1<Ret, T> &sl)
     {return long_signal_t::connect(sl);}

     Ret emit(T obj)
     {short_signal_t::emit();
     return long_signal_t::emit(obj);}

     Ret operator()(T obj)
     {short_signal_t::emit();
     return long_signal_t::emit(obj);}

     bool empty() const
     {return (short_signal_t::empty() &&
	      long_signal_t::empty());}
};

template<class Ret, class T, class P1>
class 
DualSignal1 : public SigC::Signal2<Ret, T, P1>,
	      public SigC::Signal1<Ret, P1>
{
private:
     Ret emit(P1){}; // Don't use!!!
     Ret operator()(P1){} // also 
public:
     typedef SigC::Signal1<Ret,P1> short_signal_t;
     typedef SigC::Signal2<Ret,T,P1> long_signal_t;

     Connection connect(const Slot1<Ret,P1> &sl)
     {return short_signal_t::connect(sl);}

     Connection connect(const Slot2<Ret, T,P1> &sl)
     {return long_signal_t::connect(sl);}

     Ret emit(T obj, P1 p1)
     {short_signal_t::emit(p1);
     return long_signal_t::emit(obj,p1);}

     Ret operator()(T obj, P1 p1)
     {short_signal_t::emit(p1);
     return long_signal_t::emit(obj,p1);}

     bool empty() const
     {return (short_signal_t::empty() &&
	      long_signal_t::empty());}
};

template<class Ret, class T, class P1, class P2>
class 
DualSignal2 : public SigC::Signal3<Ret, T, P1, P2>,
	     public SigC::Signal2<Ret, P1, P2>
{
private:
     Ret emit(P1,P2){}; // Don't use!!!
     Ret operator()(P1,P2){} // also 
public:
     typedef SigC::Signal2<Ret,P1,P2> short_signal_t;
     typedef SigC::Signal3<Ret,T,P1,P2> long_signal_t;

     Connection connect(const Slot2<Ret,P1,P2> &sl)
     {return short_signal_t::connect(sl);}

     Connection connect(const Slot3<Ret, T,P1,P2> &sl)
     {return long_signal_t::connect(sl);}

     Ret emit(T obj, P1 p1, P2 p2)
     {short_signal_t::emit(p1,p2);
     return long_signal_t::emit(obj,p1,p2);}

     Ret operator()(T obj, P1 p1, P2 p2)
     {short_signal_t::emit(p1,p2);
     return long_signal_t::emit(obj,p1,p2);}

     bool empty() const
     {return (short_signal_t::empty() &&
	      long_signal_t::empty());}
};

template<class Ret, class T, class P1, class P2, class P3>
class 
DualSignal3 : public SigC::Signal4<Ret, T, P1, P2, P3>,
	     public SigC::Signal3<Ret, P1, P2, P3>
{
private:
     Ret emit(P1,P2,P3){}; // Don't use!!!
     Ret operator()(P1,P2,P3){} // also 
public:
     typedef SigC::Signal3<Ret,P1,P2,P3> short_signal_t;
     typedef SigC::Signal4<Ret,T,P1,P2,P3> long_signal_t;

     Connection connect(const Slot3<Ret,P1,P2,P3> &sl)
     {return short_signal_t::connect(sl);}

     Connection connect(const Slot4<Ret, T,P1,P2,P3> &sl)
     {return long_signal_t::connect(sl);}

     Ret emit(T obj, P1 p1, P2 p2,P3 p3)
     {short_signal_t::emit(p1,p2,p3);
     return long_signal_t::emit(obj,p1,p2,p3);}

     Ret operator()(T obj, P1 p1, P2 p2, P3 p3)
     {short_signal_t::emit(p1,p2,p3);
     return long_signal_t::emit(obj,p1,p2,p3);}

     bool empty() const
     {return (short_signal_t::empty() &&
	      long_signal_t::empty());}
};

template<class Ret>
class VDKSignal0 : public DualSignal0<Ret, VDKObject*>{};

template<class Ret, class P1>
class VDKSignal1 : public DualSignal1<Ret, VDKObject*, P1>{};

template<class Ret, class P1, class P2>
class VDKSignal2 : public DualSignal2<Ret, VDKObject*, P1, P2>{};

template<class Ret, class P1, class P2, class P3>
class VDKSignal3 : public DualSignal3<Ret, VDKObject*, P1, P2, P3>{};

#endif /* USE_SIGCPLUSPLUS */
#endif /* !_sigc_addon_h_ */

