/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */


#include "vdk/vdkdate.h"
#include <string>
#include <cstdlib>
#include <cstdio>
#include <time.h>

/*
days, moths, names
*/
static int monthDays[] = 
{ 31,29,31,30,
  31,30,31,31,
  30,31,30,31
};
static char *days_name[] =
{
"Domenica","Luned","Marted",
"Mercoled","Gioved","Venerd",
 "Sabato"
};
static char *days_name_E[] =
{
"Sunday","Monday","Tuesday",
"Wednesday","Thursday","Friday",
 "Saturday"
};
static char *months_name[] =
{
"?","Gennaio","Febbraio","Marzo","Aprile",
"Maggio","Giugno","Luglio","Agosto",
"Settembre","Ottobre","Novembre","Dicembre"
};
static char *months_name_E[] =
{
"?","January","February","March","April",
"May","June","July","August",
"September","October","November","December"
};

static char internal_buffer[128];


/*
  private:
  from calendar to julian
  */
long calendardate::Julian(void)
{
  long jul;
  int ja,jy = year, jm;
  int error = 0;
  /*
	checks correct date
    */
  error = jy <= 0;
  if(! error) error = (month <= 0 || month > 12);
  if(! error) error = day > monthDays[month-1];
  if(! error && month == 2)
    error = (! Leap(year)) && (day > 28);
  if(error) return -1L;

  if(month > 2) jm = month+1;
  else { jy--; jm = month+13; }
  jul = (long) (floor(365.25*jy)+floor(30.6001*jm)+day+1720995);
  if(day+31L*(month+12L*year) >= IGREG)
    {
      ja = (int) (0.01*jy);
      jul += 2 - ja + (int) (0.25*ja);
    }
  return jul;
}
/*
  private:
  compute month and year
  */
void calendardate::Caldate(void)
{
  long ja,jalfa,jb,jc,jd,je;
  if(julian >= IGREG)
    {
      jalfa = (long)
	(((float) (julian-1867216L)-0.25)/36524.25);
      ja = julian+1+jalfa - (long) (0.25*jalfa);
    }
  else ja= julian;
  jb = ja+1524;
  jc = (long) (6680.0 + ((float) (jb-2439870L)-122.1)/365.25);
  jd = (long) (365*jc+(0.25*jc));
  je = (long) ((jb-jd)/30.6001);
  day = jb-jd-(long)(30.6001*je);
  month = je-1;
  if(month > 12) month -= 12;
  year = jc - 4715;
  if(month > 2) --year;
  if(year <= 0) --year;
}

/*
  make a date
  from system date
  */
calendardate::calendardate(int mode): mode(mode)
{
  time_t curtime;
  struct tm *loctime;
  /* Get the current time. */
  curtime = time (NULL);
  /* Convert it to local time representation. */
  loctime = localtime (&curtime);
  day = loctime->tm_mday;
  month = loctime->tm_mon+1;
  year = loctime->tm_year+1900;
  julian = Julian();
}
/*
  expects a date in mmddyyyy or ddmmyyyy format,
  use separators included in sep
  */
calendardate::calendardate(char* s, int mode, char* sep):
  mode(mode)
{
  char *p,*p1;
  int error = 0;
  std::memset(internal_buffer,(char) 0, sizeof(internal_buffer));
  std::strcpy(internal_buffer,s);
  p = p1 = internal_buffer;

  if((p1 = std::strpbrk(p,sep)) != (char*) 0)
    { 
      *p1 = '\0';
      if(mode == ddmmyyyy)
	day = atoi(p); 
      else
	month = atoi(p);
      p = ++p1; 
    }
  else error = 1;

  if (! error && (p1 = std::strpbrk(p,sep)) != (char*) 0)
    { 
      *p1 = '\0'; 
      if(mode == ddmmyyyy)
	month = atoi(p); 
      else
	day = atoi(p);
      p = ++p1; 
    }
  else error = 1;

  if (! error) year = atoi(p);
  else error = 1;
  // cast to XX century.
  year = year < 1900 ? year+1900: year;
  if(! error) julian = Julian();
  else julian = -1L;
}
/*
  stream output
  ostream& operator<<(ostream& os, calendardate& d)
  {
  if(d.day < 10) os << '0';
  os << d.day << '.';
  if(d.month < 10) os << '0';
  os << d.month << '.';
  os << d.year;
  if(d.julian < 0L) os << "(!)";
   return os;
  }
*/
/*
  return formatted date
  */
calendardate::operator char*()
{
  if(julian < 0) return "invalid";
  if(mode == ddmmyyyy)
    sprintf(internal_buffer,"%02d/%02d/%d",day,month,year);
  else
    sprintf(internal_buffer,"%02d/%02d/%d",month,day,year);
  return internal_buffer;
}
/*
in yyyymmdd format
*/
char* calendardate::AsString()
{
  if(julian < 0) return "invalid";
  sprintf(internal_buffer,"%4d%02d%02d",year,month,day);
  return internal_buffer;
}
char* calendardate::CalendarDate()
{
  if(mode == ddmmyyyy)
    sprintf(internal_buffer,"%s %d %s %d",
	    days_name[DayIndex()],
	    day,
	    months_name[month],
	    year);
  else
    sprintf(internal_buffer,"%s %s %d %d",
	    days_name_E[DayIndex()],
	    months_name_E[month],
	    day,
	    year);
    return internal_buffer;	
}

char* calendardate::InternalBuffer()
{ return internal_buffer; }
/*
expect a date in
yyyymmdd format
*/
calendardate MakeDate(char* s,int mode)
{
calendardate today(mode);
int d,m,y;
if(std::strlen(s) != 8)
    return today;
char buffer[9];
std::strcpy(buffer,s);
d = std::atoi(&buffer[6]);
buffer[6] = '\0';
m = std::atoi(&buffer[4]);
buffer[4] = '\0';
y = std::atoi(buffer);
return calendardate(d,m,y,mode);
}
