/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class GaussianReader
extends MOReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private String energyString = "";
    private String energyKey = "";
    private int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    private int stepNumber;

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Step number")) {
            this.equivalentAtomSets = 0;
            ++this.stepNumber;
            int n = this.line.indexOf("scan point");
            this.scanPoint = n > 0 ? this.parseInt(this.line, n + 10) : -1;
            return true;
        }
        if (this.line.indexOf("-- Stationary point found") > 0) {
            if (this.scanPoint >= 0) {
                ++this.scanPoint;
            }
            return true;
        }
        if (this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0) {
            if (!this.doGetModel(++this.modelNumber)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            if (Logger.debugging) {
                Logger.debug(" model " + this.modelNumber + " step " + this.stepNumber + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line);
            }
            this.readAtoms();
            return false;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" Energy=")) {
            this.setEnergy();
            return true;
        }
        if (this.line.startsWith(" SCF Done:")) {
            this.readSCFDone();
            return true;
        }
        if (this.line.startsWith(" Harmonic frequencies")) {
            this.readFrequencies();
            return true;
        }
        if (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:")) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith(" Dipole moment")) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.startsWith(" Standard basis:")) {
            Logger.debug(this.line);
            this.energyUnits = "";
            this.calculationType = this.line.substring(17).trim();
            return true;
        }
        if (this.line.startsWith(" General basis read from cards:")) {
            Logger.debug(this.line);
            this.energyUnits = "";
            this.calculationType = this.line.substring(31).trim();
            return true;
        }
        if (this.line.startsWith(" AO basis set")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals();
            if (Logger.debugging) {
                Logger.debug(this.orbitals.size() + " molecular orbitals read");
            }
            return true;
        }
        if (this.line.startsWith(" Normal termination of Gaussian")) {
            ++this.calculationNumber;
            this.equivalentAtomSets = 0;
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        String[] stringArray = GaussianReader.getTokens(this.line, 11);
        if (stringArray.length < 4) {
            return;
        }
        this.energyKey = stringArray[0];
        this.energyString = stringArray[2] + " " + stringArray[3];
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyString, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(this.energyKey, this.energyString, this.equivalentAtomSets);
        stringArray = GaussianReader.getTokens(this.readLine());
        if (stringArray.length > 2) {
            this.atomSetCollection.setAtomSetProperties(stringArray[0], stringArray[2], this.equivalentAtomSets);
            if (stringArray.length > 5) {
                this.atomSetCollection.setAtomSetProperties(stringArray[3], stringArray[5], this.equivalentAtomSets);
            }
            stringArray = GaussianReader.getTokens(this.readLine());
        }
        if (stringArray.length > 2) {
            this.atomSetCollection.setAtomSetProperties(stringArray[0], stringArray[2], this.equivalentAtomSets);
        }
    }

    private void setEnergy() {
        String[] stringArray = this.getTokens();
        this.energyKey = "Energy";
        this.energyString = stringArray[1];
        this.atomSetCollection.setAtomSetNames("Energy = " + stringArray[1], this.equivalentAtomSets);
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyString);
        String string = this.getTokens()[0];
        this.discardLines(4);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String[] stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)this.parseInt(stringArray[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            int n = stringArray.length - 3;
            atom.x = this.parseFloat(stringArray[n]);
            atom.y = this.parseFloat(stringArray[++n]);
            atom.z = this.parseFloat(stringArray[++n]);
        }
        this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + string);
    }

    private void readBasis() throws Exception {
        String[] stringArray;
        boolean bl;
        this.shells = new Vector();
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        this.gaussianCount = 0;
        this.shellCount = 0;
        String string = "";
        boolean bl2 = this.calculationType != null && this.calculationType.indexOf("5D") > 0;
        boolean bl3 = bl = this.calculationType != null && this.calculationType.indexOf("7F") > 0;
        while (this.readLine() != null && this.line.startsWith(" Atom")) {
            ++this.shellCount;
            stringArray = this.getTokens();
            int[] nArray = new int[4];
            if (!stringArray[1].equals(string)) {
                ++n;
            }
            string = stringArray[1];
            nArray[0] = n - 1;
            String string2 = stringArray[4];
            nArray[1] = bl && string2.indexOf("F") >= 0 || bl2 && string2.indexOf("D") >= 0 ? JmolAdapter.getQuantumShellTagIDSpherical(string2) : JmolAdapter.getQuantumShellTagID(string2);
            int n2 = this.parseInt(stringArray[5]);
            nArray[2] = this.gaussianCount;
            nArray[3] = n2;
            this.shells.addElement(nArray);
            this.gaussianCount += n2;
            for (int i = 0; i < n2; ++i) {
                vector.addElement(GaussianReader.getTokens(this.readLine()));
            }
        }
        if (n == 0) {
            n = 1;
        }
        this.gaussians = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            stringArray = (String[])vector.get(i);
            this.gaussians[i] = new float[stringArray.length];
            for (int j = 0; j < stringArray.length; ++j) {
                this.gaussians[i][j] = this.parseFloat(stringArray[j]);
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    private void readMolecularOrbitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        Hashtable[] hashtableArray = new Hashtable[5];
        Vector[] vectorArray = new Vector[5];
        int n = 0;
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int n2;
            String[] stringArray;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(n, vectorArray, hashtableArray);
                stringArray = GaussianReader.getTokens(this.readLine());
                n = stringArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2] = new Hashtable();
                    vectorArray[n2] = new Vector();
                    String string = stringArray[n2];
                    hashtableArray[n2].put("symmetry", string);
                    if (string.indexOf("--O") >= 0) {
                        hashtableArray[n2].put("occupancy", new Float(2.0f));
                        continue;
                    }
                    if (string.indexOf("--V") < 0) continue;
                    hashtableArray[n2].put("occupancy", new Float(0.0f));
                }
                this.line = this.readLine().substring(21);
                stringArray = this.getTokens();
                if (stringArray.length != n) {
                    stringArray = GaussianReader.getStrings(this.line, n, 10);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2].put("energy", new Float(stringArray[n2]));
                }
                continue;
            }
            if (this.line.length() < 21 || this.line.charAt(11) != ' ' && !Character.isDigit(this.line.charAt(11))) continue;
            try {
                stringArray = GaussianReader.getStrings(this.line.substring(21), n, 10);
                for (n2 = 0; n2 < n; ++n2) {
                    vectorArray[n2].addElement(stringArray[n2]);
                }
            }
            catch (Exception exception) {
                Logger.error("Error reading Gaussian file Molecular Orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(n, vectorArray, hashtableArray);
        this.setMOData(false);
    }

    private void readFrequencies() throws Exception, IOException {
        this.discardLinesUntilContains(":");
        if (this.line == null) {
            throw new Exception("No frequencies encountered");
        }
        while ((this.line = this.readLine()) != null && this.line.length() > 15) {
            String[] stringArray = GaussianReader.getTokens(this.readLine());
            String[] stringArray2 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Frequencies"), 15);
            String[] stringArray3 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Red. masses"), 15);
            String[] stringArray4 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Frc consts"), 15);
            String[] stringArray5 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" IR Inten"), 15);
            int n = this.atomSetCollection.getAtomCount();
            int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
            int n3 = stringArray2.length;
            boolean[] blArray = new boolean[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(stringArray[i] + " " + stringArray2[i] + " cm^-1");
                this.atomSetCollection.setAtomSetProperty(this.energyKey, this.energyString);
                this.atomSetCollection.setAtomSetProperty("Frequency", stringArray2[i] + " cm^-1");
                this.atomSetCollection.setAtomSetProperty("ReducedMass", stringArray3[i] + " AMU");
                this.atomSetCollection.setAtomSetProperty("ForceConstant", stringArray4[i] + " mDyne/A");
                this.atomSetCollection.setAtomSetProperty("IRIntensity", stringArray5[i] + " KM/Mole");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            this.discardLinesUntilContains(" AN ");
            this.fillFrequencyData(n, n2, n2, blArray, true, 0, 0, null);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] stringArray = GaussianReader.getTokens(this.readLine());
        if (stringArray.length != 8) {
            return;
        }
        Vector3f vector3f = new Vector3f(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[5]));
        Logger.info("Molecular dipole for model " + this.atomSetCollection.getAtomSetCount() + " = " + vector3f);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", vector3f);
    }

    void readPartialCharges() throws Exception {
        this.discardLines(1);
        int n = this.atomSetCollection.getAtomCount();
        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n2; i < n; ++i) {
            float f;
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            atomArray[i].partialCharge = f = this.parseFloat(GaussianReader.getTokens(this.readLine())[2]);
        }
        Logger.info("Mulliken charges found for Model " + this.atomSetCollection.getAtomSetCount());
    }
}

