#############################################################################
# Author:                                                                   #
# ------                                                                    #
#  Anton Kokalj                                  Email: Tone.Kokalj@ijs.si  #
#  Department of Physical and Organic Chemistry  Phone: x 386 1 477 3523    #
#  Jozef Stefan Institute                          Fax: x 386 1 477 3811    #
#  Jamova 39, SI-1000 Ljubljana                                             #
#  SLOVENIA                                                                 #
#                                                                           #
# Source: $XCRYSDEN_TOPDIR/Tcl/groups.tcl                                       
# ------                                                                    #
# Copyright (c) 1996-2003 by Anton Kokalj                                   #
#############################################################################

proc point_group {} {
    global group_list
    
    set group_list [ list \
	    {  1:   P 1            } \
	    {  2:   P -1           } \
	    {  3:   P 2 1 1        } \
	    {  4:   P 1 2 1        } \
	    {  5:   P 1 1 2        } \
	    {  6:   P M 1 1        } \
	    {  7:   P 1 M 1        } \
	    {  8:   P 1 1 M        } \
	    {  9:   P 2/M 1 1      } \
	    { 10:   P 1 2/M 1      } \
	    { 11:   P 1 1 2/M      } \
	    { 12:   P 2 2 2        } \
	    { 13:   P 2 M M        } \
	    { 14:   P M 2 M        } \
	    { 15:   P M M 2        } \
	    { 16:   P M M M        } \
	    { 17:   P 4            } \
	    { 18:   P -4           } \
	    { 19:   P 4/M          } \
	    { 20:   P 4 2 2        } \
	    { 21:   P 4 M M        } \
	    { 22:   P -4 2 M       } \
	    { 23:   P -4 M 2       } \
	    { 24:   P 4/M M M      } \
	    { 25:   P 3            } \
	    { 26:   P -3           } \
	    { 27:   P 3 2 1        } \
	    { 28:   P 3 1 2        } \
	    { 29:   P 3 M 1        } \
	    { 30:   P 3 1 M        } \
	    { 31:   P -3 M 1       } \
	    { 32:   P -3 1 M       } \
	    { 33:   P 6            } \
	    { 34:   P -6           } \
	    { 35:   P 6/M          } \
	    { 36:   P 6 2 2        } \
	    { 37:   P 6 M M        } \
	    { 38:   P -6 M 2       } \
	    { 39:   P -6 2 M       } \
	    { 40:   P 6/M M M      } \
	    { 41:   P 2 3          } \
	    { 42:   P M 3          } \
	    { 43:   P 4 3 2        } \
	    { 44:   P -4 3 M       } \
	    { 45:   P M 3 M        } ]
}


proc line_group {} {
    global group_list

    set group_list [ list \
	    {  1:   P 1            }  \
	    {  2:   P -1           }  \
	    {  3:   P 1 1 2        }  \
	    {  4:   P 1 1 21       }  \
	    {  5:   P 1 2 1        }  \
	    {  6:   P 2 1 1        }  \
	    {  7:   P 1 1 M        }  \
	    {  8:   P 1 M 1        }  \
	    {  9:   P 1 C 1        }  \
	    { 10:   P M 1 1        }  \
	    { 11:   P C 1 1        }  \
            { 12:   P 1 1 2/M      }  \
            { 13:   P 1 1 21/M     }  \
            { 14:   P 1 2/M 1      }  \
            { 15:   P 1 2/C 1      }  \
            { 16:   P 2/M 1 1      }  \
            { 17:   P 2/C 1 1      }  \
            { 18:   P 2 2 2        }  \
            { 19:   P 2 2 21       }  \
            { 20:   P M M 2        }  \
            { 21:   P M C 21       }  \
            { 22:   P C M 21       }  \
            { 23:   P C C 2        }  \
            { 24:   P M 2 M        }  \
            { 25:   P C 2 M        }  \
            { 26:   P 2 M M        }  \
            { 27:   P 2 C M        }  \
            { 28:   P M M M        }  \
            { 29:   P C C M        }  \
            { 30:   P C M M        }  \
            { 31:   P M C M        }  \
            { 32:   P 4            }  \
            { 33:   P 41           }  \
            { 34:   P 42           }  \
            { 35:   P 43           }  \
            { 36:   P -4           }  \
            { 37:   P 4/M          }  \
            { 38:   P 42/M         }  \
            { 39:   P 4 2 2        }  \
            { 40:   P 41 2 2       }  \
            { 41:   P 42 2 2       }  \
            { 42:   P 43 2 2       }  \
            { 43:   P 4 M M        }  \
            { 44:   P 42 C M       }  \
            { 45:   P 4 C C        }  \
            { 46:   P 42 M C       }  \
            { 47:   P -4 2 M       }  \
            { 48:   P -4 2 C       }  \
            { 49:   P -4 M 2       }  \
            { 50:   P -4 C 2       }  \
            { 51:   P 4/M M M      }  \
            { 52:   P 4/M C C      }  \
            { 53:   P 42/M M C     }  \
            { 54:   P 42/M C M     }  \
            { 55:   P 3            }  \
            { 56:   P 31           }  \
            { 57:   P 32           }  \
            { 58:   P -3           }  \
            { 59:   P 3 1 2        }  \
            { 60:   P 31 1 2       }  \
            { 61:   P 32 1 2       }  \
            { 62:   P 3 2 1        }  \
            { 63:   P 31 2 1       }  \
            { 64:   P 32 2 1       }  \
            { 65:   P 3 M 1        }  \
            { 66:   P 3 C 1        }  \
            { 67:   P 3 1 M        }  \
            { 68:   P 3 1 C        }  \
            { 69:   P -3 1 M       }  \
            { 70:   P -3 1 C       }  \
            { 71:   P -3 M 1       }  \
            { 72:   P -3 C 1       }  \
            { 73:   P 6            }  \
            { 74:   P 61           }  \
            { 75:   P 65           }  \
            { 76:   P 62           }  \
            { 77:   P 64           }  \
            { 78:   P 63           }  \
            { 79:   P -6           }  \
            { 80:   P 6/M          }  \
            { 81:   P 63/M         }  \
            { 82:   P 6 2 2        }  \
            { 83:   P 61 2 2       }  \
            { 84:   P 65 2 2       }  \
            { 85:   P 62 2 2       }  \
            { 86:   P 64 2 2       }  \
            { 87:   P 63 2 2       }  \
            { 88:   P 6 M M        }  \
            { 89:   P 6 C C        }  \
            { 90:   P 63 C M       }  \
            { 91:   P 63 M C       }  \
            { 92:   P -6 M 2       }  \
            { 93:   P -6 C 2       }  \
            { 94:   P -6 2 M       }  \
            { 95:   P -6 2 C       }  \
            { 96:   P 6/M M M      }  \
            { 97:   P 6/M C C      }  \
            { 98:   P 63/M C M     }  \
            { 99:   P 63/M M C     } ]
}


proc plane_group {} {
    global group_list
   
    set group_list [ list \
	    {  1:   P 1            } \
	    {  2:   P -1           } \
	    {  3:   P 1 1 2        } \
	    {  4:   P 1 1 M        } \
	    {  5:   P 1 1 A        } \
	    {  6:   P 1 1 2/M      } \
	    {  7:   P 1 1 2/A      } \
	    {  8:   P 2 1 1        } \
	    {  9:   P 21 1 1       } \
	    { 10:   C 2 1 1        } \
	    { 11:   P M 1 1        } \
	    { 12:   P B 1 1        } \
	    { 13:   C M 1 1        } \
	    { 14:   P 2/M 1 1      } \
	    { 15:   P 21/M 1 1     } \
	    { 16:   C 2/M 1 1      } \
	    { 17:   P 2/B 1 1      } \
	    { 18:   P 21/B 1 1     } \
	    { 19:   P 2 2 2        } \
            { 20:   P 2 21 2       } \
            { 21:   P 21 21 2      } \
            { 22:   C 2 2 2        } \
            { 23:   P M M 2        } \
            { 24:   P M A 2        } \
            { 25:   P B A 2        } \
            { 26:   C M M 2        } \
            { 27:   P 2 M M        } \
            { 28:   P 21 A M       } \
            { 29:   P 21 M A       } \
            { 30:   P 2 M B        } \
            { 31:   P 21 M N       } \
            { 32:   P 2 A A        } \
            { 33:   P 21 A B       } \
            { 34:   P 2 A N        } \
            { 35:   C 2 M M        } \
            { 36:   C 2 M B        } \
            { 37:   P M M M        } \
            { 38:   P M A M        } \
            { 39:   P M M A        } \
            { 40:   P M M N        } \
            { 41:   P B A M        } \
            { 42:   P M A A        } \
            { 43:   P M A N        } \
            { 44:   P B M A        } \
            { 45:   P B A A        } \
            { 46:   P B A N        } \
            { 47:   C M M M        } \
            { 48:   C M M A        } \
            { 49:   P 4            } \
            { 50:   P -4           } \
            { 51:   P 4/M          } \
            { 52:   P 4/N          } \
            { 53:   P 4 2 2        } \
            { 54:   P 4 21 2       } \
            { 55:   P 4 M M        } \
            { 56:   P 4 B M        } \
            { 57:   P -4 2 M       } \
            { 58:   P -4 21 M      } \
            { 59:   P -4 M 2       } \
            { 60:   P -4 B 2       } \
            { 61:   P 4/M M M      } \
            { 62:   P 4/N B M      } \
            { 63:   P 4/M B M      } \
            { 64:   P 4/N M M      } \
            { 65:   P 3            } \
            { 66:   P -3           } \
            { 67:   P 3 1 2        } \
            { 68:   P 3 2 1        } \
            { 69:   P 3 M 1        } \
            { 70:   P 3 1 M        } \
            { 71:   P -3 1 M       } \
            { 72:   P -3 M 1       } \
            { 73:   P 6            } \
            { 74:   P -6           } \
            { 75:   P 6/M          } \
            { 76:   P 6 2 2        } \
            { 77:   P 6 M M        } \
            { 78:   P -6 M 2       } \
            { 79:   P -6 2 M       } \
            { 80:   P 6/M M M      } ]
}

proc space_group {} {
    global group_list
    
    set group_list [ list \
	    {  1:   P 1            } \
	    {  2:   P -1           } \
	    {  3:   P 2            } \
	    {  4:   P 21           } \
	    {  5:   C 2            } \
	    {  6:   P M            } \
	    {  7:   P C            } \
	    {  8:   C M            } \
	    {  9:   C C            } \
	    { 10:   P 2/M          } \
	    { 11:   P 21/M         } \
	    { 12:   C 2/M          } \
	    { 13:   P 2/C          } \
	    { 14:   P 21/C         } \
	    { 15:   C 2/C          } \
	    { 16:   P 2 2 2        } \
	    { 17:   P 2 2 21       } \
	    { 18:   P 21 21 2      } \
	    { 19:   P 21 21 21     } \
	    { 20:   C 2 2 21       } \
	    { 21:   C 2 2 2        } \
	    { 22:   F 2 2 2        } \
	    { 23:   I 2 2 2        } \
	    { 24:   I 21 21 21     } \
	    { 25:   P M M 2        } \
	    { 26:   P M C 21       } \
	    { 27:   P C C 2        } \
	    { 28:   P M A 2        } \
	    { 29:   P C A 21       } \
	    { 30:   P N C 2        } \
	    { 31:   P M N 21       } \
	    { 32:   P B A 2        } \
	    { 33:   P N A 21       } \
	    { 34:   P N N 2        } \
	    { 35:   C M M 2        } \
	    { 36:   C M C 21       } \
	    { 37:   C C C 2        } \
	    { 38:   A M M 2        } \
	    { 39:   A B M 2        } \
	    { 40:   A M A 2        } \
	    { 41:   A B A 2        } \
	    { 42:   F M M 2        } \
	    { 43:   F D D 2        } \
	    { 44:   I M M 2        } \
	    { 45:   I B A 2        } \
	    { 46:   I M A 2        } \
	    { 47:   P M M M        } \
	    { 48:   P N N N        } \
	    { 49:   P C C M        } \
	    { 50:   P B A N        } \
	    { 51:   P M M A        } \
	    { 52:   P N N A        } \
	    { 53:   P M N A        } \
	    { 54:   P C C A        } \
	    { 55:   P B A M        } \
	    { 56:   P C C N        } \
	    { 57:   P B C M        } \
	    { 58:   P N N M        } \
	    { 59:   P M M N        } \
	    { 60:   P B C N        } \
	    { 61:   P B C A        } \
	    { 62:   P N M A        } \
	    { 63:   C M C M        } \
	    { 64:   C M C A        } \
	    { 65:   C M M M        } \
	    { 66:   C C C M        } \
	    { 67:   C M M A        } \
	    { 68:   C C C A        } \
	    { 69:   F M M M        } \
	    { 70:   F D D D        } \
	    { 71:   I M M M        } \
	    { 72:   I B A M        } \
	    { 73:   I B C A        } \
	    { 74:   I M M A        } \
	    { 75:   P 4            } \
	    { 76:   P 41           } \
	    { 77:   P 42           } \
	    { 78:   P 43           } \
	    { 79:   I 4            } \
	    { 80:   I 41           } \
	    { 81:   P -4           } \
	    { 82:   I -4           } \
	    { 83:   P 4/M          } \
	    { 84:   P 42/M         } \
	    { 85:   P 4/N          } \
	    { 86:   P 42/N         } \
	    { 87:   I 4/M          } \
	    { 88:   I 41/A         } \
	    { 89:   P 4 2 2        } \
	    { 90:   P 4 21 2       } \
	    { 91:   P 41 2 2       } \
	    { 92:   P 41 21 2      } \
	    { 93:   P 42 2 2       } \
	    { 94:   P 42 21 2      } \
	    { 95:   P 43 2 2       } \
	    { 96:   P 43 21 2      } \
	    { 97:   I 4 2 2        } \
	    { 98:   I 41 2 2       } \
	    { 99:   P 4 M M        } \
	    {100:   P 4 B M        } \
	    {101:   P 42 C M       } \
	    {102:   P 42 N M       } \
	    {103:   P 4 C C        } \
	    {104:   P 4 N C        } \
	    {105:   P 42 M C       } \
	    {106:   P 42 B C       } \
	    {107:   I 4 M M        } \
	    {108:   I 4 C M        } \
	    {109:   I 41 M D       } \
	    {110:   I 41 C D       } \
	    {111:   P -4 2 M       } \
 	    {112:   P -4 2 C       } \
 	    {113:   P -4 21 M      } \
 	    {114:   P -4 21 C      } \
 	    {115:   P -4 M 2       } \
 	    {116:   P -4 C 2       } \
 	    {117:   P -4 B 2       } \
 	    {118:   P -4 N 2       } \
 	    {119:   I -4 M 2       } \
 	    {120:   I -4 C 2       } \
 	    {121:   I -4 2 M       } \
 	    {122:   I -4 2 D       } \
 	    {123:   P 4/M M M      } \
 	    {124:   P 4/M C C      } \
 	    {125:   P 4/N B M      } \
 	    {126:   P 4/N N C      } \
 	    {127:   P 4/M B M      } \
 	    {128:   P 4/M N C      } \
 	    {129:   P 4/N M M      } \
 	    {130:   P 4/N C C      } \
 	    {131:   P 42/M M C     } \
 	    {132:   P 42/M C M     } \
 	    {133:   P 42/N B C     } \
 	    {134:   P 42/N N M     } \
 	    {135:   P 42/M B C     } \
 	    {136:   P 42/M N M     } \
 	    {137:   P 42/N M C     } \
 	    {138:   P 42/N C M     } \
 	    {139:   I 4/M M M      } \
 	    {140:   I 4/M C M      } \
 	    {141:   I 41/A M D     } \
 	    {142:   I 41/A C D     } \
 	    {143:   P 3            } \
 	    {144:   P 31           } \
 	    {145:   P 32           } \
 	    {146:   R 3            } \
 	    {147:   P -3           } \
 	    {148:   R -3           } \
 	    {149:   P 3 1 2        } \
 	    {150:   P 3 2 1        } \
 	    {151:   P 31 1 2       } \
 	    {152:   P 31 2 1       } \
 	    {153:   P 32 1 2       } \
 	    {154:   P 32 2 1       } \
 	    {155:   R 3 2          } \
 	    {156:   P 3 M 1        } \
 	    {157:   P 3 1 M        } \
 	    {158:   P 3 C 1        } \
 	    {159:   P 3 1 C        } \
 	    {160:   R 3 M          } \
 	    {161:   R 3 C          } \
 	    {162:   P -3 1 M       } \
 	    {163:   P -3 1 C       } \
 	    {164:   P -3 M 1       } \
 	    {165:   P -3 C 1       } \
 	    {166:   R -3 M         } \
 	    {167:   R -3 C         } \
 	    {168:   P 6            } \
 	    {169:   P 61           } \
 	    {170:   P 65           } \
 	    {171:   P 62           } \
 	    {172:   P 64           } \
 	    {173:   P 63           } \
 	    {174:   P -6           } \
 	    {175:   P 6/M          } \
 	    {176:   P 63/M         } \
 	    {177:   P 6 2 2        } \
 	    {178:   P 61 2 2       } \
 	    {179:   P 65 2 2       } \
 	    {180:   P 62 2 2       } \
 	    {181:   P 64 2 2       } \
 	    {182:   P 63 2 2       } \
 	    {183:   P 6 M M        } \
 	    {184:   P 6 C C        } \
 	    {185:   P 63 C M       } \
 	    {186:   P 63 M C       } \
 	    {187:   P -6 M 2       } \
 	    {188:   P -6 C 2       } \
 	    {189:   P -6 2 M       } \
 	    {190:   P -6 2 C       } \
 	    {191:   P 6/M M M      } \
 	    {192:   P 6/M C C      } \
 	    {193:   P 63/M C M     } \
 	    {194:   P 63/M M C     } \
 	    {195:   P 2 3          } \
 	    {196:   F 2 3          } \
 	    {197:   I 2 3          } \
 	    {198:   P 21 3         } \
 	    {199:   I 21 3         } \
 	    {200:   P M 3          } \
 	    {201:   P N 3          } \
 	    {202:   F M 3          } \
 	    {203:   F D 3          } \
 	    {204:   I M 3          } \
 	    {205:   P A 3          } \
 	    {206:   I A 3          } \
 	    {207:   P 4 3 2        } \
 	    {208:   P 42 3 2       } \
 	    {209:   F 4 3 2        } \
 	    {210:   F 41 3 2       } \
 	    {211:   I 4 3 2        } \
 	    {212:   P 43 3 2       } \
 	    {213:   P 41 3 2       } \
 	    {214:   I 41 3 2       } \
 	    {215:   P -4 3 M       } \
 	    {216:   F -4 3 M       } \
 	    {217:   I -4 3 M       } \
 	    {218:   P -4 3 N       } \
 	    {219:   F -4 3 C       } \
 	    {220:   I -4 3 D       } \
 	    {221:   P M 3 M        } \
 	    {222:   P N 3 N        } \
 	    {223:   P M 3 N        } \
 	    {224:   P N 3 M        } \
 	    {225:   F M 3 M        } \
 	    {226:   F M 3 C        } \
 	    {227:   F D 3 M        } \
 	    {228:   F D 3 C        } \
 	    {229:   I M 3 M        } \
 	    {230:   I A 3 D        } ]
}
