/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name: tools.c
 * Abstract:	Programming Tools word set
 */

#include <stdio.h>
#include "yforth.h"
#include "tools.h"
#include "core.h"

/**************************************************************************/
/* WORDS ******************************************************************/
/**************************************************************************/

void _dot_s() {
	register Cell *p = sp;
	while (p < sp_top) {
		*--sp = *p;
		_dot();
		p++;
	}
}

void _question() {
	_fetch();
	_dot();
}

void _dump() {
	register UCell u = *sp++;
	register Char *addr = (Char *) *sp++;
	while (u) {
		register int i;
		printf("%08p: ", addr);
		for (i = 0; i < 16; i++)
			if ((int) (u - i) > 0) printf("%02x ", *(addr + i) & 0xff);
			else printf("   ");
		for (i = 0; i < 16 && (u - i) > 0; i++)
			printf("%c", *(addr + i) < 32 ? '.' : *(addr + i));
		putchar('\n');
		addr += i;
		u -= i;
	}
}

void _see() {
	_error = E_NOPRIM;
}

void _words() {
	register int i = 0;
	register struct word_def *p;
	register Cell col = 1;
	while (i < VOC_HASH) {
		p = voc->voc[i++];
		while (p) {
			*--sp = (Cell) p->name;
			_count();
			if (col + sp[0] > 79) {
				col = 1;
				_c_r();
			}
			col += sp[0] + 1;
			_type();
			_b_l();
			_emit();
			p = p->link;
		}
	}
}

